#include <stdio.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <stdlib.h>
#include <math.h>

char *readline(const char *prompt);
static char *prompt = "===> ";
char *line;

#define	  PARMLEN  1024

#define   NFUN   (sizeof(fun_tab)/sizeof(char *))
#define   NCON   (sizeof(con_tab)/sizeof(struct con_ent))

char parm[PARMLEN],*i;
char answer[25];
int token[PARMLEN];
double reg[PARMLEN/2+1];
int stack[PARMLEN/2+1];
int top;
int p,r,k;
int error;
char outline[PARMLEN+1];
static char *fun_tab[] = {
    "abs", "acos", "asin", "atanh", "atan", "cosh", "cos", "exp",
    "log2", "log10", "log", "sinh", "sin", "sqrt", "tanh", "tan"
};
static struct con_ent {
    char *sym;
    char *val;
} con_tab[] = {
    {"pi", "3.141592653589793238"},
    {"e", "2.718281828459045235"}
};
int len;


main()
{
    while (len = getparm(parm, PARMLEN)) {
        error = 0;
	i = parm;
	p = r = 0;
	expr();
	if (i!=parm+len || error)
	    syntax_error();
	else {
	    puttoken(1);
	    infix_postfix();
	    evaluate();	    
	    printf("     %s\n\n", answer);
	}
    }
}

    
expr()
{
    term();
    switch(*i) {
    case('+'):
        puttoken(3);
        expr();
        return;
    case('-'):
        puttoken(4);
        expr();
        return;
    }
}
    
term()
{
    factor();
    switch(*i) {
    case('*'):
        puttoken(5);
        term();
        return;
    case('/'):
        puttoken(6);
        term();
        return;
    }
}

    
factor()
{
    operand();
    if (strhead(i,"**")) {
        puttoken(7);
        factor();
    }
}
    

operand()
{
    char c;
    int k;
	
    c = *i;
    if (c=='-') {
        puttoken(11);
        operand();
    } else if (c=='(') {
        puttoken(2);
        expr();
        if (*i==')')
            puttoken(8);
        else
            syntax_error();
    } else if (c>='a' && c<='z') {
        for (k = 0; k<NFUN; ++k)
            if (strhead(i, fun_tab[k])) {
       	        puttoken(k+12);
	        if (*i=='(')
	            operand();
	        else
	            syntax_error();
	        return;
	    }
	for (k = 0; k<NCON; ++k)
            if (strhead(i, con_tab[k].sym)) {
    	        putnumber(con_tab[k].val, strlen(con_tab[k].val));
	        i += strlen(con_tab[k].sym);
	        return;
	    }
	syntax_error();
    } else
        unsigned_num();
}	

    
unsigned_num()
{
    static char *table[] = {
        "d4.1", "d5", "d6+3-3", "d6", "d4.5e2", "d5e2", "d7", "d8", ""
    };
    int s,found;
    char a,b;
    char *j;
    	
    j = i;
    s = 0;
    found = 1;
    while (found) {
        found = 0;
        k = 0;
        a = *table[s];
        b = *j;
        while (!found && a!='\0') {
       	    if (a=='d') {
	        if (b>='0' && b<='9')
	            found = 1;
	    } else
	        if (a==b)
	            found = 1;
	    k += 2;
	    a = *(table[s]+k);
	}
        if (found) {
            ++j;
	    s = *(table[s]+k-1)-'0';
	}
    }
    if (s>3) {
	putnumber(i,j-i);
	i = j;
    } else {
	i = j;
	syntax_error();
    }
}

    
infix_postfix()
{
    int p,q,t;
	
    stack[0] = 1;
    top = 0;
    t = token[0];
    p = 1;
    q = 0;
    while (t!=1) {
	if (t>50)
	    token[q++] = t;
	else if (t>10 || t==2)
	    stack[++top] = t;
	else if (t>2 && t<8) {
	    while (t<=stack[top])
		token[q++] = stack[top--];	
	    stack[++top] = t;
	} else {
	    while (stack[top]!=2)
		token[q++] = stack[top--];
	    --top;
	}
	t = token[p++];
    }
    while (stack[top]!=1)
	token[q++] = stack[top--];
    token[q] = 1;
}

    
evaluate()
{

    int p,t;
    double op1,op2;

    top = -1;
    p = 0;
    t = token[0];
    while (t!=1) {
	if (t>=50)
	    stack[++top] = t-50;
	else if (t<11) {
	    op2 = reg[stack[top--]];
	    op1 = reg[stack[top]];
	    switch(t) {
	    case(3):
		op1 = op1+op2;
		break;
	    case(4):
		op1 = op1-op2;
		break;
	    case(5):
		op1 = op1*op2;
		break;
	    case(6):
		op1 = op1/op2;
		break;
	    case(7):
		op1 = exp(log(op1)*op2);
	    }
	    reg[stack[top]] = op1;
	} else {
	    op1 = reg[stack[top]];
	    switch(t) {
    	    case(11):
		op1 = -op1;
		break;
	    case(12):
		op1 = abs(op1);
		break;
	    case(13):
		op1 = acos(op1);
		break;
	    case(14):
		op1 = asin(op1);
		break;
	    case(15):
		op1 = log((1+op1)/(1-op1))/2;
		break;
	    case(16):
		op1 = atan(op1);
		break;
	    case(17):
		op1 = cosh(op1);
		break;
	    case(18):
		op1 = cos(op1);
		break;
	    case(19):
		op1 = exp(op1);
		break;
	    case(20):
		op1 = log(op1)/log(2);
		break;
	    case(21):
		op1 = log10(op1);
		break;
	    case(22):
		op1 = log(op1);
		break;
	    case(23):
		op1 = sinh(op1);
		break;
	    case(24):
		op1 = sin(op1);
		break;
	    case(25):
		op1 = sqrt(op1);
		break;
	    case(26):
		op1 = tanh(op1);
		break;
	    case(27):
		op1 = tan(op1);
            }
	    reg[stack[top]] = op1;
	}
	t = token[++p];
    }       
    gcvt(reg[0], 16, answer);
}

    
puttoken(t)
int t;
{
    token[p++] = t;
    if (t==7)
	i += 2;
    else if (t<12)
	++i;
    else
	i += strlen(fun_tab[t-12]);
}

    
putnumber(i,l)
char *i;
int l;
{
    char buf[PARMLEN];
    int k;

    for (k = 0; k<l; ++k)
	buf[k] = *i++;
    buf[k] = '\0';
    reg[r] = atof(buf);
    token[p++] = (r++)+50;
}

    
syntax_error()
{
    if (!error) {
	printf("-----");
	while (i--!=parm)
	    printf("-");
	printf("*\nUnexpected Character.\n");
	error = 1;
	i = "";
    }
}

    
int strhead(i,s)
char *i,*s;
{
    while (*s!='\0' && *i++==*s)
	++s;
    return(*s=='\0');
}
    

int getparm(s, lim)
char s[];
int lim;
{
    int c, i, j;
    
    i = 0;
    do {
        line = readline(prompt);
        if (line == NULL) {
	    printf("\n");
            return(0);
	}
        while (i<lim && (c = line[i]) != '\n' && c != '\0')
            s[i++] = c;
	free(line);
        if (i==lim) {
	    printf("calc: Expression too long.");
	    i = 0;
	}
    } while (!i);
    s[i] = '\0';
    add_history(s);
    return(i);
}
